#ifndef _C4D_GEDATA_H_
#define _C4D_GEDATA_H_

#include "ge_math.h"

class BaseContainer;
class BaseTime;
class String;
class Filename;
class AliasTrans;
class BaseLink;
class BaseList2D;
class BaseDocument;
struct CustomDataType;

enum GeDataType
{
	DA_NIL						= 0,
	DA_LONG						= 15,
	DA_REAL						= 19,
	DA_TIME						= 22,
	DA_VECTOR					= 23,
	DA_MATRIX					= 25,
	DA_BYTEARRAY			= 128,  // mainly for quicktime
	DA_STRING					= 130,
	DA_FILENAME				= 131,
	DA_CONTAINER			= 132, 	// BaseContainer
	DA_ALIASLINK			= 133,  // for alias links -> new in 7300
	DA_MARKER					= 256,
	DA_MISSINGPLUG		= 257,	// missing datatype plugin

	DA_CUSTOMDATATYPE = 1000000, // DataTypes > 1000000 are custom

	DA_END
};

enum DEFAULTVALUETYPE
{
	DEFAULTVALUE
};

class GeData
{
	private:
	  GeDataType Type;

	  union
  	{
    	LONG						DInteger;
	    Real						DReal;
  		void*						Ddata;
	  };

	public:
		// constructors
		GeData(void);
		GeData(int    n);
		GeData(double n);

		GeData(const GeData &n);

		GeData(LONG  n);
		GeData(Real  n);
		GeData(const Vector   &n);
		GeData(const Matrix   &n);
		GeData(const String   &n);
		GeData(const Filename &n);
		GeData(const BaseTime &n);
		GeData(const BaseContainer &n);
		GeData(const BaseLink &n);
		GeData(LONG type,const CustomDataType &data);
		GeData(LONG type,DEFAULTVALUETYPE v);

		// destructor
		~GeData(void);

		// operators
		const GeData &operator = (const GeData &gd);
		Bool operator == (const GeData &d) const;
		Bool operator != (const GeData &d) const;

		// functions
		void Free(void); // delete internal data

		GeDataType GetType(void) const;

		// take care: the results are only valid as long as the GeData value exists
		LONG									GetLong     (void) const;
		Real									GetReal     (void) const;
		const Vector&					GetVector   (void) const;
		const Matrix&					GetMatrix   (void) const;
		const String&					GetString   (void) const;
		const Filename&				GetFilename (void) const;
		const BaseTime&				GetTime     (void) const;
		BaseContainer*				GetContainer(void) const;
		BaseLink*							GetBaseLink (void) const;
		CustomDataType*				GetCustomDataType	(LONG datatype) const;
		BaseList2D*						GetLink(BaseDocument *doc, LONG instanceof=0) const;

		void CopyData(GeData *dest,AliasTrans *aliastrans) const;
};

class BrowseContainer
{
	private:
		BaseContainer *t_bc;
		void*					handle;

	public:
		BrowseContainer(const BaseContainer *bc);
		void Reset(void);
		Bool GetNext(LONG *id,GeData **data);
};

#endif
